import requests, time, csv
from bs4 import BeautifulSoup

# 最初に読み込むURL
target_url = 'https://yamashina.iehohs.com/'

html = requests.get(target_url).text
soup = BeautifulSoup(html, 'html5lib')
res = []

# １つ目のentry-list内にあるh4を取得
div = soup.select('.entry-list')[0]
h4_list = div.find_all('h4')

# すべてのh4を走査
for h4 in h4_list:
    title = h4.text                 # 記事タイトル
    url = h4.find('a').get('href')  # リンク先のURL
    
    # 記事内に入りh2を取得
    html2 = requests.get(url).text
    soup2 = BeautifulSoup(html2, 'html5lib')
    div2 = soup2.select('.entry-content')[0]
    h2_list = div2.find_all('h2')
    h2_str = ""

    # h2を「、」で繋ぐ
    for h2 in h2_list:
        h2_str = h2_str + h2.text + "、"

    # 投稿日を取得
    date = soup2.select('.post-date')[0].text
    
    # 配列に格納
    res.append([date, title, url, h2_str])
    
    # 負荷軽減のため１秒遅延させる
    time.sleep(1)

# CSV出力
with open('list.csv', 'wt', encoding='sjis', newline="") as fp:
    csv.writer(fp).writerows(res)